CREATE OR REPLACE FUNCTION TSystem.views__wawi_Eingangsrechnung__drop() RETURNS VOID AS $$
  BEGIN

    DROP FUNCTION IF EXISTS TWawi.extend_layout__beleg__dms(TWawi.rechnunge_belegext);
    DROP FUNCTION IF EXISTS TWawi.extend_layout__beleg__notes(TWawi.rechnunge_belegext);        

    DROP FUNCTION IF EXISTS TWawi.view__pos__normalize(TWawi.rechnunge_pos);
    DROP FUNCTION IF EXISTS TWawi.view__beleg__normalize(TWawi.rechnunge_belegext);

    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS TWawi.erechnung_posext;
        DROP VIEW IF EXISTS TWawi.erechnung_pos;

        DROP VIEW IF EXISTS TWawi.rechnunge_posall;
        DROP VIEW IF EXISTS TWawi.rechnunge_posext; -- neu analog TSystem_Wawi
        DROP VIEW IF EXISTS TWawi.rechnunge_pos;

        DROP VIEW IF EXISTS TWawi.rechnunge_belegext;
    --
    
    RETURN;

  END $$ LANGUAGE plpgsql; 

--
CREATE OR REPLACE FUNCTION TSystem.views__Wawi_Eingangsrechnung__recreate() RETURNS VOID AS $f0$
  BEGIN

    PERFORM TSystem.views__wawi_Eingangsrechnung__drop();

    CREATE OR REPLACE VIEW TWawi.rechnunge_belegext AS
      SELECT
        eingrechdokument.dbrid                                       AS dbrid, -- wegen datarowstate!
        eingrechdokument.dbrid                                       AS d_dbrid,
        beld_dokunr                                                  AS d_dokunr,
        beld_id                                                      AS d_id,

        null                                                         AS d_aproz, --An/Abschlagsrechnung-Prozent

        beld_belegart                                                AS d_typ,
        d_code,
        beld_definitiv                                               AS d_definitiv,
        eingrechdokument.insert_date                                 AS d_insert_date,
        eingrechdokument.insert_by                                   AS d_insert_by,
        beld_erstelldatum                                            AS d_datum_erfasst,

        extract(year FROM beld_erstelldatum)::integer                AS d_datum_erfasst__year,
        extract(week FROM beld_erstelldatum)::integer                AS d_datum_erfasst__week,
        extract(quarter FROM beld_erstelldatum)::integer             AS d_datum_erfasst__quarter,
        extract(month FROM beld_erstelldatum)::integer               AS d_datum_erfasst__month,

        coalesce(beld_titel, lang_belegart(beld_belegart))           AS d_titel,
        coalesce(beld_kopftext_rtf, beld_kopftext)                   AS d_kopftext,
        coalesce(beld_fusstext_rtf, beld_fusstext)                   AS d_fusstext,
        beld_kopftext                                                AS d_kopftext_txt,
        beld_fusstext                                                AS d_fusstext_txt,

        adk_ad_krz::varchar(30)                                      AS d_adk_ad_krz, --richtiges Adresskürzel (Liefer/Rechnungs-Unteradresskürzel)
        adressename( adk_ad_krz )                                    AS d_adk_ad_krz__name,
        beld_krzrechnung                                             AS d_ada_krzl,

        beld_apkrzl                                                  AS d_apext,
        beld_ap                                                      AS d_apextname,

        beld_refbeleg                                                AS d_refnummer,-- Referenz auf ext.Nummer (Z.Bsp. Bestell-Nr. Kunde)

        beld_apint                                                   AS d_apint,
        nameAufloesen(beld_apint)                                    AS d_apintname,

        ad_ustidnr                                                   AS d_ad_ustidnr,

        beld_zak                                                     AS d_zahlung_tage,
        beld_skv                                                     AS d_zahlung_skv,
        beld_sks                                                     AS d_zahlung_sks,
        beld_zakbem                                                  AS d_zahlung_bemerkung,
        beld_erstelldatum + beld_zak                                 AS d_datum_soll,
        beld_exportdatum                                             AS d_datum_fibu_buchung, -- Datum des Exports in die Buchhaltungsschnittstelle
        beld_verbucht                                                AS d_zahlung_done,        

        wert_gs_faktor,
        beld_netto              * wert_gs_faktor                     AS d_wert_tot_netto,
        beld_brutto             * wert_gs_faktor                     AS d_wert_tot_brutto,

        beld_netto_basis_w      * wert_gs_faktor                     AS d_wert_tot_netto_gwaer,
        beld_brutto_basis_w     * wert_gs_faktor                     AS d_wert_tot_brutto_gwaer,

        a2_knr                                                       AS d_adk_knr,

        beld_abschlussdatum                                          AS d_abschlussdatum,
        beld_geprueft                                                AS d_geprueft,
        beld_freigabe                                                AS d_freigabe,
        beld_pruefer                                                 AS d_pruefer,
        beld_pruefdatum                                              AS d_pruefdatum,
        beld_krzlieferung                                            AS d_krz_lieferung,
        beld_krzbesteller                                            AS d_krz_besteller,

        COALESCE(beld_waehr, TSystem.Settings__BASIS_W__Get() )::VARCHAR(10)        AS d_waco
      FROM eingrechdokument

        JOIN LATERAL (SELECT CASE WHEN beld_belegart /*d_typ*/ = 2 THEN 'G' ELSE 'R' END::varchar(5) AS d_code) AS codestat ON true
        JOIN LATERAL (SELECT CASE WHEN beld_belegart /*d_typ*/ = 2 THEN -1 ELSE 1  END AS wert_gs_faktor) AS negativ ON true

        LEFT JOIN adressen_view ON ad_krz = beld_krzrechnung --wegen Kreditorendaten
        LEFT JOIN adk2          ON a2_krz = adk_ad_krz       --Kreditorendaten zur Adresse
        LEFT JOIN adkap         ON adk_ad_krz = ap_ad_krz AND ap_krzl = beld_apkrzl AND ap_krzl IS NOT NULL
      ORDER BY
        beld_erstelldatum DESC, beld_dokunr DESC
    ;

    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    CREATE OR REPLACE VIEW TWawi.rechnunge_pos AS
      SELECT
      -- Identifikatoren
        dbrid                                   AS dbrid                   ,--
        belp_id                                 AS p_id                    ,-- ID der Pos.
        --beld_dokunr                           AS p_dokunr                ,-- Referenz auf das zug. Dokument

        --beld_belegart                         AS p_code                  ,-- Code / Klassifikation / Rechnung/Gutschrift
        belp_dokument_id                        AS p_d_id                  ,
        --                                      AS p_nummer                ,-- Belegnummer
        belp_pos                                AS p_pos                   ,-- Positionsnummer
        belp_hauptpos                           AS p_parent                ,-- Übergeordnete Position (Strukt. Belege)
        --'rechnunge_pos'::varchar AS p_table            ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        belp_aknr                               AS p_aknr                  ,-- Artikelnummer
        --                                      AS p_aknr_idx              ,-- Artikelindex
        belp_akbez                              AS p_akbz                  ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        belp_referenzaknr                       AS p_aknr_referenz         ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        belp_menge                              AS p_menge                 ,-- Menge in Positions-ME
        belp_mce                                AS p_me                    ,-- artmgc.m_id der Positions-ME
        --                                      AS p_los                   ,-- Losgröße für Artikel
        belp_menge_gme                          AS p_menge_gme             ,-- Menge in GME
        --                                      AS p_mengeb_gme            ,-- Menge bestellt in GME
        --                                      AS p_mengel_gme            ,-- Menge geliefert in GME
        --                                      AS p_mengef_gme            ,-- Menge fakturiert in GME
        --                                      AS p_mengeo                ,-- Offene Menge
        --                                      AS p_mengeo_gme            ,-- Offene Menge in GME
        --                                      AS p_norm                  ,-- Artikelnorm
        belp_kostenstelle                       AS p_ks                    ,-- Zugeordnete Kostenstelle
        --                                      AS p_gme                   ,-- artmgc.m_id der Grundmengeneinheit
        --                                      AS p_mec                   ,-- ME-Code der Positions-ME
        --                                      AS p_gmec                  ,-- ME-Code der Grund-ME
        --                                      AS p_meuf                  ,-- Umrechnungsfaktor von Pos.ME zu GME
      -- Preisdaten
        belp_preis                              AS p_preis                 ,-- Preis pro ME (enthält Preiseinheit)
        belp_preiseinheit                       AS p_preiseinheit          ,-- Menge auf die sich p_preis bezieht
        --                                      AS p_preis_me              ,-- Preis pro ME
        belp_preis_basis_w                      AS p_preis_gwaer           ,-- Preis pro ME in Grundwährung
        belp_preis_gme                          AS p_preis_gme             ,-- Preis pro GME
        belp_preis_gme_basis_w                  AS p_preis_gme_gwaer       ,-- Preis pro GME in Grundwährung
        belp_waehr                              AS p_waco                  ,-- Pos. Währungseinheit
        belp_kurs                               AS p_kurs                  ,-- Pos. Kurs zur Basiswährung
        belp_steucode                           AS p_steu_code             ,-- Steuercode
        belp_steuproz                           AS p_steu_proz             ,-- Steuerprozentsatz
        belp_rabatt                             AS p_rabatt                ,-- Rabattsatz (0...100)
        belp_rabattfaehig                       AS p_rabatt_able           ,-- Kennzeichen Rabattfähig

        --belp_netto          AS p_wert_tot_netto            ,-- Positionswert inkl. AbZuschläge, exkl. Steuern
        --belp_brutto         AS p_wert_tot_brutto           ,-- Positionswert inkl. AbZuschläge, inkl. Steuern
        --belp_netto_basis_w  AS p_wert_tot_netto_gwaer      ,-- Positionswert inkl. AbZuschläge, exkl. Steuern, in Grundwährung
        --belp_brutto_basis_w AS p_wert_tot_brutto_gwaer     ,-- Positionswert inkl. AbZuschläge, inkl. Steuern, in Grundwährung

        --true              AS p_wert_zero_no_umsatz     ,-- Kennzeichen umsatzwirksame Position

      -- Adressdaten
        belp_krzrechnung                        AS p_adk_ad_krz            ,-- Adresskürzel Rechnungsadresse. Aus unserer Sicht ist der Eingangsrechnungssteller der Lieferant. Wichtigste Adresse hier ist der Lieferant, daher p_adkrzt
        belp_krzlieferung                       AS p_ada_krzl              ,-- Adresskürzel Lieferadresse
        belp_krzbesteller                       AS p_ada_krzf              ,-- Adresskürzel Rechnungsadresse. Aus unserer Sicht sind wir das selbst! Der Besteller (also wir) bekommen die Rechnung.
        --                                      AS p_apext                 ,-- Kürzel Ansprechpartner extern
        --                                      AS p_apextname             ,-- Voller Name Ansprechpartner extern
        --                                      AS p_apint                 ,-- Kürzel Ansprechpartner intern
        --                                      AS p_apintname             ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        insert_date                             AS p_insert_date           ,-- Eingangsdatum
        belp_erstelldatum                       AS p_datum_erfasst         ,-- Erfassdatum
        --                                      AS p_datum_soll            ,-- Wunschdatum          -- belp_termin ? nie gefüllt
        --                                      AS p_datum_ist             ,-- Bestätigtes Datum    -- belp_termin_bestaetigt, belp_termin_verschoben ? nie gefüllt
        --                                      AS p_datum_istsoll         ,-- COALESCE(Bestätigtes, Wunschdatum)
        --                                      AS p_datum_fibu_buchung    ,-- Datum des Exports in die Buchhaltungsschnittstelle
        --                                      AS p_datum_storniert       ,-- Datum an dem die Pos. Storniert wurde
        --                                       AS p_definitiv             ,-- Kennzeichen Pos. Definitiv
        belp_erledigt                           AS p_done                  ,-- Kennzeichen Pos. Erledigt
        belp_storniert                          AS p_storniert             ,-- Kennzeichen Pos. Storniert
        --                                      AS p_IsBedarf              ,-- Kennzeichen bedarfswirksam
        --                                      AS p_IsFertigung           ,-- Kennzeichen Fertigungsartikel
        --                                      AS p_IsUmsatz              ,-- Kennzeichen umsatzwirksame Position
        --                                      AS p_status                ,-- Allg. Status1
        --                                      AS p_status1               ,-- Allg. Status2
        --                                      AS p_status2               ,-- Allg. Status3
      -- Referenzen / Struktur
        --                                      AS p_rahmen_id             ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        --                                      AS p_vorgaenger_table      ,--
        belp_ld_id                              AS p_vorgaenger_id         ,--
        belp_referenz                           AS p_refnummer             ,-- Referenz auf ext.Nummer (Z.Bsp. Bestell-Nr. Kunde)
        --                                      AS p_refpos                ,-- Referenz auf ext.Position (Z.Bsp. Bestellpos. - Kunde)
        belp_projektnummer                      AS p_an_nr                 ,-- Projektnummer
        --                                      AS p_vtp_id                ,-- ID der zugehörigen Vertragsposition
        --                                      AS p_ab_ix                 ,-- Zugehörige ABK
        --                                      AS p_q_nr                  ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        belp_konto                              AS p_Konto                 ,--
        belp_dokutxt                            AS p_txt_ext               ,--
        belp_dokutxt_rtf                        AS p_txt_ext_rtf           ,--
        belp_txt                                AS p_txt_int               ,--
        belp_txt_rtf                            AS p_txt_int_rtf           ,--

        belp_w_wen                              AS p_w_wen

        FROM eingrech_pos                       AS er_p -- ist auch updateable view
    ;

    -- Erweiterter Anzeige-View => Nur lesbar. Felder aus Basis-View und angejointen Tabellen.
    CREATE OR REPLACE VIEW TWawi.rechnunge_posext AS
      SELECT
        pos.dbrid                             AS dbrid,
        p_id,
        p_d_id,
        
        d_typ                                 AS p_typ,          -- Klassifikation als ID
        d_code                                AS p_code,          -- übersetzter Code (aus Lateral Join o.Ä.)

        d_dokunr                              AS p_dokunr,        -- Referenz auf das zug. Dokument

        p_parent,
        'rechnunge_pos'::varchar(64)          AS p_table,

        d_definitiv                           AS p_definitiv,

        d_adk_ad_krz                          AS p_adk_ad_krz,

        -- Zusätzliche oder erweiterte Artikeldaten
        d_waco                               AS d_waer,
        COALESCE(ld_aknr_idx, ak_idx)        AS p_aknr_idx,
        COALESCE(pos.p_akbz, ak_bez)         AS p_ak_bez,
        COALESCE(p_aknr_referenz, ld_bem)    AS p_aknr_referenz,
        ak_los                               AS p_los,
        NULL::NUMERIC                        AS p_mengeb_gme,
        NULL::NUMERIC                        AS p_mengel_gme,
        NULL::NUMERIC                        AS p_mengef_gme,
        p_menge                              AS p_mengeo,
        p_menge_gme                          AS p_mengeo_gme,
        ak_norm                              AS p_norm,

        -- Mengeneinheitsdaten
        MEData.p_gme,
        MEData.p_mec,
        MEData.p_gmec,
        MEData.p_meuf,
        MEData.p_meiso,
        MEData.p_gmeiso,

        -- Berechnete Preisdaten
        false                                AS p_preis_sumsubpos,
        belp_preis / Do1If0(p_preiseinheit)  AS p_preis_me,

        -- Steuerbezeichnung
        steu_txt                              AS p_steu_bez,
        steu_txt                              AS p_sbez,

        -- Werteberechnungen
        belp_netto              * wert_gs_faktor  AS p_wert_tot_netto,
        belp_brutto             * wert_gs_faktor  AS p_wert_tot_brutto,
        belp_netto_basis_w      * wert_gs_faktor  AS p_wert_tot_netto_gwaer,
        belp_brutto_basis_w     * wert_gs_faktor  AS p_wert_tot_brutto_gwaer,

        -- Status-Flags & Logikfelder
        false                                AS p_nstatistik,
        true                                 AS p_IsUmsatz,
        beld_apkrzl                          AS p_apext,
        beld_ap                              AS p_apExtName,
        beld_apint                           AS p_apInt,
        nameAufloesen(beld_apint)            AS p_apintname,

        -- Zusätzliche Termindaten
        p_insert_date                        AS p_insert_date,        
        d_datum_erfasst                      AS p_datum_erfasst         ,-- Erfassdatum
        beld_erstelldatum + COALESCE(beld_zak, 0) AS p_datum_soll,
        beld_erstelldatum + COALESCE(beld_zak, 0) AS p_datum_ist,
        beld_erstelldatum + COALESCE(beld_zak, 0) AS p_datum_istsoll,
        beld_exportdatum                    AS p_datum_fibu_buchung,
        NULL::DATE                          AS p_datum_storniert,

        -- Erweiterte Statusangaben
        true                                 AS p_IsBedarf,
        ak_fertigung                         AS p_IsFertigung,
        NULL::VARCHAR                        AS p_status,
        NULL::VARCHAR                        AS p_status1,
        NULL::VARCHAR                        AS p_status2,

        -- Weitere Referenzdaten
        ld_a2_id                             AS p_a2_id,
        NULL::INTEGER                        AS p_rahmen_id,
        'ldsdok'::VARCHAR                    AS p_vorgaenger_table,

        -- Projekt-/Vertragsstruktur
        NULL::INTEGER                        AS p_refpos,
        NULL::INTEGER                        AS p_vtp_id,
        NULL::INTEGER                        AS p_ab_ix,
        NULL::INTEGER                        AS p_q_nr,

        -- Zusatzdaten
        lang_belart(beld_belegart)           AS p_belegart,
        ak_ac                                AS p_akac

      FROM TWawi.rechnunge_pos AS pos

        JOIN TWawi.rechnunge_belegext ON p_d_id = d_id

        JOIN eingrech_pos      ON belp_id = p_id
        JOIN eingrechdokument  ON beld_id = belp_dokument_id

        JOIN art               ON ak_nr   = p_aknr

        LEFT JOIN adressen_view ON ad_krz = beld_krzrechnung --wegen Kreditorendaten
        LEFT JOIN adk2          ON a2_krz = adk_ad_krz       --Kreditorendaten zur Adresse

        LEFT JOIN ldsdok       ON ld_id   = belp_ld_id
        LEFT JOIN steutxt      ON steu_z  = p_steu_code
        -- Informationen zur Mengenumrechnung mit aufnehmen
        , LATERAL( SELECT m2.m_id     AS p_gme,
                          m1.m_mgcode AS p_mec,
                          m2.m_mgcode AS p_gmec,
                          m1.m_uf     AS p_meuf,
                          lang_artmgc_id_iso(p_me)    AS p_meiso,
                          lang_artmgc_id_iso(m2.m_id) AS p_gmeiso
                   FROM art JOIN artmgc m1  ON (m1.m_ak_nr  = ak_nr) AND (m1.m_id = p_me)
                            JOIN artmgc m2  ON (m2.m_ak_nr  = ak_nr) AND (m2.m_mgcode = ak_standard_mgc)
                   WHERE m1.m_ak_nr = pos.p_aknr ) AS medata
    --  WHERE  beld_belegtyp = 'ERG' => bereits im view eingrech_pos!
    ;

    PERFORM TSystem.view__combined__create('twawi', 'rechnunge_pos', 'rechnunge_posext', 'rechnunge_posall');

    CREATE OR REPLACE VIEW TWawi.erechnung_pos    AS SELECT * FROM TWawi.rechnunge_pos; -- TODO => Prüfen alte Viewnamen gleich ersetzen durch rechnunge_ (analog TSystem_WawI)
    CREATE OR REPLACE VIEW TWawi.erechnung_posext AS SELECT * FROM TWawi.rechnunge_posext;


    --
    EXECUTE $f1$

          CREATE OR REPLACE FUNCTION TWawi.view__pos__normalize(IN _p TWawi.rechnunge_pos)
            RETURNS SETOF TWawi.view__pos__type
            AS $$
                WITH data AS (SELECT (_p).*)
                SELECT
                    dbrid                   ,
                    p_id                    ,
                    p_d_id                  ,
                    p_pos                   ,
                    false --p_preis_sumsubpos
                FROM data
            $$ LANGUAGE sql STABLE PARALLEL SAFE;

          CREATE OR REPLACE FUNCTION TWawi.view__beleg__normalize(IN _b TWawi.rechnunge_belegext)
            RETURNS SETOF TWawi.view__beleg__type
            AS $$
                WITH data AS (SELECT (_b).*)
                SELECT
                    dbrid,
                    d_id,
                    d_code,
                    d_wert_tot_netto,
                    d_wert_tot_brutto,
                    d_wert_tot_netto_gwaer,
                    d_wert_tot_brutto_gwaer,
                    d_datum_erfasst,
                    d_zahlung_tage,
                    d_zahlung_done 
                FROM data
            $$ LANGUAGE sql;


          -- DMS Dokumentvorschau           
          CREATE OR REPLACE FUNCTION TWawi.extend_layout__beleg__dms(IN _b TWawi.rechnunge_belegext)
            RETURNS TABLE (
              DMS_get_dok_exists            boolean,
              preview_dokid                 integer,
              repository_tablename          varchar(64),
              repository_dbrid              varchar(64)
              )
              AS $$
                SELECT   -- DMS Dokumentvorschau
                    TDMS.Dokument__exists__by__dbrid( _b.d_dbrid ),
                    TDMS.Dokument__pd_id__by__pd_dbrid__pd_doktype(_b.d_dbrid, 'werech', 'eingrechdokument')  AS preview_dokid,  -- Dokumentvorschau
                    'eingrechdokument'             AS repository_tablename,
                    _b.d_dbrid                     AS repository_dbrid ---belkopf.dbrid,                                                                                             
              $$ LANGUAGE sql STABLE PARALLEL SAFE;

          CREATE OR REPLACE FUNCTION TWawi.extend_layout__beleg__notes(IN _b TWawi.rechnunge_belegext)
            RETURNS TABLE (
             menu_dbrid                    varchar(64),
             menu_tablename                varchar(64),
             menu_category                 varchar(64),
             menu_dbrid_2                  varchar(64),
             menu_tablename_2              varchar(64),
             menu_category_2               varchar(64),
             get_record_has_note           boolean
             )
             AS $$
                SELECT   -- DMS Dokumentvorschau
                       _b.dbrid                     AS menu_dbrid, 
                       'eingrechdokument'           AS menu_tablename, 
                       null                         AS menu_category,  -- Notizen Arbeitsgang

                       null                         AS menu_dbrid_2, 
                       null                         AS menu_tablename_2, 
                       null                         AS menu_category_2,  -- Notizen ABK

                       get_record_has_note(_b.dbrid) /*OR get_record_has_note(abk.dbrid, 'Auswärts')*/ AS get_record_has_note                                                                                           
            $$ LANGUAGE sql STABLE PARALLEL SAFE;             
          --  

    $f1$; -- EXECUTE end


  END $f0$ LANGUAGE plpgsql;
--

--- SELECT TSystem.views__Wawi_Eingangsrechnung__recreate();